package com.ejie.ab04b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.Folder;

/**
 * Ab0477s00DaoImpl generated by UDA, 07-jun-2017 11:54:50.
 * @author UDA
 */
 
@Repository
@Transactional
public class FolderDaoImpl implements FolderDao {
    private JdbcTemplate jdbcTemplate;
	
	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Folder> rwMap = new RowMapper<Folder>() {
		public Folder mapRow(ResultSet resultSet, int rowNum) throws SQLException {
           return new Folder(
               resultSet.getString("TIPEXP077"), resultSet.getString("TEREXP077"), resultSet.getString("ANOEXP077"), resultSet.getInt("NUMEXP077"), resultSet.getString("ORDEXP077"), resultSet.getString("FOLDERID077"), resultSet.getString("CARTAPROMOTOR077"), resultSet.getString("CARTACOORDINADOR077"), resultSet.getString("CARTAOS2077"), resultSet.getString("CARTAOS2OS3077"), resultSet.getString("TAREAESTUDIO"), resultSet.getString("ESTADO077"), resultSet.getDate("FECESTADO077"), resultSet.getClob("CTXSUB077"), resultSet.getString("CARTACONTRATISTA077")
           ); } } ;
           
	private RowMapper<Folder> rwMapPK = new RowMapper<Folder>() {
		public Folder mapRow(ResultSet resultSet, int rowNum) throws SQLException {
			return new Folder(
				resultSet.getString("TIPEXP077"), resultSet.getString("TEREXP077"), resultSet.getString("ANOEXP077"), resultSet.getInt("NUMEXP077"), resultSet.getString("ORDEXP077"), resultSet.getString("FOLDERID077"), resultSet.getString("CARTAPROMOTOR077"), resultSet.getString("CARTACOORDINADOR077"), resultSet.getString("CARTAOS2077"), resultSet.getString("CARTAOS2OS3077"), resultSet.getString("TAREAESTUDIO"), resultSet.getString("ESTADO077"), resultSet.getDate("FECESTADO077"), resultSet.getClob("CTXSUB077"), resultSet.getString("CARTACONTRATISTA077")
           ); } } ;

	/**
     * Rowmapper para Jerarquía
     *
 dataSource DataSource

     */
	private RowMapper<JerarquiaDto< Folder>> rwMapJerarquia = new RowMapper<JerarquiaDto<Folder>>() {
		public JerarquiaDto<Folder> mapRow(ResultSet resultSet, int rowNum) throws SQLException {
	
			Folder ab0477s00 = new Folder(resultSet.getString("TIPEXP077"), resultSet.getString("TEREXP077"), resultSet.getString("ANOEXP077"), resultSet.getInt("NUMEXP077"), resultSet.getString("ORDEXP077"), resultSet.getString("FOLDERID077"), resultSet.getString("CARTAPROMOTOR077"), resultSet.getString("CARTACOORDINADOR077"), resultSet.getString("CARTAOS2077"), resultSet.getString("CARTAOS2OS3077"), resultSet.getString("TAREAESTUDIO"), resultSet.getString("ESTADO077"), resultSet.getDate("FECESTADO077"), resultSet.getClob("CTXSUB077"), resultSet.getString("CARTACONTRATISTA077"));

			JerarquiaDto<Folder> jerarquia = new JerarquiaDto<Folder>();
			jerarquia.setModel(ab0477s00);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet.getString("FILTER")));
			return jerarquia;
		}
	};


	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource DataSource
	 *
	 * @param dataSource the new data source
	 */
    @Resource
    public void setDataSource(DataSource dataSource) {
    	this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

	/*
	 * OPERACIONES CRUD
	 */

    /**
	 * Inserts a single row in the Ab0477s00 table.
	 * 
	 *  ab0477s00 Ab0477s00
	 *  Ab0477s00
	 *
	 * @param ab0477s00 the ab 0477 s 00
	 * @return the folder
	 */
	public Folder add(Folder ab0477s00) {
    	String query = "INSERT INTO AB0477S00 (TIPEXP_077, TEREXP_077, ANOEXP_077, NUMEXP_077, ORDEXP_077, FOLDERID_077, CARTAPROMOTOR_077, CARTACOORDINADOR_077, CARTAOS2_077, CARTAOS2OS3_077, TAREAESTUDIO, ESTADO_077, FECESTADO_077, CTXSUB_077, CARTACONTRATISTA_077) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, ab0477s00.getTipexp077(), ab0477s00.getTerexp077(), ab0477s00.getAnoexp077(), ab0477s00.getNumexp077(), ab0477s00.getOrdexp077(), ab0477s00.getFolderid077(), ab0477s00.getCartapromotor077(), ab0477s00.getCartacoordinador077(), ab0477s00.getCartaos2077(), ab0477s00.getCartaos2os3077(), ab0477s00.getTareaestudio(), ab0477s00.getEstado077(), ab0477s00.getFecestado077(), ab0477s00.getCtxsub077(), ab0477s00.getCartacontratista077());
		return ab0477s00;
	}

    /**
     * Updates a single row in the Ab0477s00 table.
     * 
     *  ab0477s00 Ab0477s00
     *  Ab0477s00
     *
     * @param ab0477s00 the ab 0477 s 00
     * @return the folder
     */
    public Folder update(Folder ab0477s00) {
		String query = "UPDATE AB0477S00 SET ORDEXP_077=?, FOLDERID_077=?, CARTAPROMOTOR_077=?, CARTACOORDINADOR_077=?, CARTAOS2_077=?, CARTAOS2OS3_077=?, TAREAESTUDIO=?, ESTADO_077=?, FECESTADO_077=?, CTXSUB_077=?, CARTACONTRATISTA_077=? WHERE TIPEXP_077=? AND TEREXP_077=? AND ANOEXP_077=? AND NUMEXP_077=? ";
		this.jdbcTemplate.update(query, ab0477s00.getOrdexp077(), ab0477s00.getFolderid077(), ab0477s00.getCartapromotor077(), ab0477s00.getCartacoordinador077(), ab0477s00.getCartaos2077(), ab0477s00.getCartaos2os3077(), ab0477s00.getTareaestudio(), ab0477s00.getEstado077(), ab0477s00.getFecestado077(), ab0477s00.getCtxsub077(), ab0477s00.getCartacontratista077(), ab0477s00.getTipexp077(), ab0477s00.getTerexp077(), ab0477s00.getAnoexp077(), ab0477s00.getNumexp077());
		return ab0477s00;
	}
    
    /**
     * Updates a single row in the Ab0477s00 table.
     * 
     *  ab0477s00 Ab0477s00
     *  Ab0477s00
     *
     * @param ab0477s00 the ab 0477 s 00
     * @return the folder
     */
    public Folder updateFolderId(Folder ab0477s00) {
		String query = "UPDATE AB0477S00 SET FOLDERID_077=? WHERE TIPEXP_077=? AND TEREXP_077=? AND ANOEXP_077=? AND NUMEXP_077=? ";
		this.jdbcTemplate.update(query, ab0477s00.getFolderid077(), ab0477s00.getTipexp077(), ab0477s00.getTerexp077(), ab0477s00.getAnoexp077(), ab0477s00.getNumexp077());
		return ab0477s00;
	}

    /**
     * Finds a single row in the Ab0477s00 table.
     * 
     *  ab0477s00 Ab0477s00
     *  Ab0477s00
     *
     * @param ab0477s00 the ab 0477 s 00
     * @return the folder
     */
    @Transactional (readOnly = true)
    public Folder find(Folder ab0477s00) {
		String query = "SELECT t1.TIPEXP_077 TIPEXP077, t1.TEREXP_077 TEREXP077, t1.ANOEXP_077 ANOEXP077, t1.NUMEXP_077 NUMEXP077, t1.ORDEXP_077 ORDEXP077, t1.FOLDERID_077 FOLDERID077, t1.CARTAPROMOTOR_077 CARTAPROMOTOR077, t1.CARTACOORDINADOR_077 CARTACOORDINADOR077, t1.CARTAOS2_077 CARTAOS2077, t1.CARTAOS2OS3_077 CARTAOS2OS3077, t1.TAREAESTUDIO TAREAESTUDIO, t1.ESTADO_077 ESTADO077, t1.FECESTADO_077 FECESTADO077, t1.CTXSUB_077 CTXSUB077, t1.CARTACONTRATISTA_077 CARTACONTRATISTA077 FROM AB0477S00 t1  WHERE t1.TIPEXP_077 = ?   AND t1.TEREXP_077 = ?   AND t1.ANOEXP_077 = ?   AND t1.NUMEXP_077 = ?   AND t1.ORDEXP_077 = ?   AND t1.FOLDERID_077 = ?   AND t1.CARTAPROMOTOR_077 = ?   AND t1.CARTACOORDINADOR_077 = ?   AND t1.CARTAOS2_077 = ?   AND t1.CARTAOS2OS3_077 = ?   AND t1.TAREAESTUDIO = ?   AND t1.ESTADO_077 = ?   AND t1.FECESTADO_077 = ?   AND t1.CTXSUB_077 = ?   AND t1.CARTACONTRATISTA_077 = ?  ";
		
		List<Folder> ab0477s00List = this.jdbcTemplate.query(query, this.rwMap, ab0477s00.getTipexp077() , ab0477s00.getTerexp077() , ab0477s00.getAnoexp077() , ab0477s00.getNumexp077() , ab0477s00.getOrdexp077() , ab0477s00.getFolderid077() , ab0477s00.getCartapromotor077() , ab0477s00.getCartacoordinador077() , ab0477s00.getCartaos2077() , ab0477s00.getCartaos2os3077() , ab0477s00.getTareaestudio() , ab0477s00.getEstado077() , ab0477s00.getFecestado077() , ab0477s00.getCtxsub077() , ab0477s00.getCartacontratista077());
		return (Folder) DataAccessUtils.uniqueResult(ab0477s00List);
    }
    
    /**
     * Finds a single row in the Ab0477s00 table.
     * 
     *  ab0477s00 Ab0477s00
     *  Ab0477s00
     *
     * @param ab0477s00 the ab 0477 s 00
     * @return the folder
     */
    @Transactional (readOnly = true)
    public Folder findByPk(Folder ab0477s00) {
		String query = "SELECT t1.TIPEXP_077 TIPEXP077, t1.TEREXP_077 TEREXP077, t1.ANOEXP_077 ANOEXP077, t1.NUMEXP_077 NUMEXP077, t1.ORDEXP_077 ORDEXP077, t1.FOLDERID_077 FOLDERID077, t1.CARTAPROMOTOR_077 CARTAPROMOTOR077, t1.CARTACOORDINADOR_077 CARTACOORDINADOR077, t1.CARTAOS2_077 CARTAOS2077, t1.CARTAOS2OS3_077 CARTAOS2OS3077, t1.TAREAESTUDIO TAREAESTUDIO, t1.ESTADO_077 ESTADO077, t1.FECESTADO_077 FECESTADO077, t1.CTXSUB_077 CTXSUB077, t1.CARTACONTRATISTA_077 CARTACONTRATISTA077 FROM AB0477S00 t1  WHERE t1.TIPEXP_077 = ?   AND t1.TEREXP_077 = ?   AND t1.ANOEXP_077 = ?   AND t1.NUMEXP_077 = ? ";
		
		List<Folder> ab0477s00List = this.jdbcTemplate.query(query, this.rwMap, ab0477s00.getTipexp077() , ab0477s00.getTerexp077() , ab0477s00.getAnoexp077() , ab0477s00.getNumexp077());
		return (Folder) DataAccessUtils.uniqueResult(ab0477s00List);
    }

    /**
     * Removes a single row in the Ab0477s00 table.
     * 
     *  ab0477s00 Ab0477s00
     *
     * @param ab0477s00 the ab 0477 s 00
     */
    public void remove(Folder ab0477s00) {
		String query = "DELETE FROM AB0477S00 WHERE TIPEXP_077=? AND TEREXP_077=? AND ANOEXP_077=? AND NUMEXP_077=? AND ORDEXP_077=? AND FOLDERID_077=? AND CARTAPROMOTOR_077=? AND CARTACOORDINADOR_077=? AND CARTAOS2_077=? AND CARTAOS2OS3_077=? AND TAREAESTUDIO=? AND ESTADO_077=? AND FECESTADO_077=? AND CTXSUB_077=? AND CARTACONTRATISTA_077=?";
		this.jdbcTemplate.update(query, ab0477s00.getTipexp077() , ab0477s00.getTerexp077() , ab0477s00.getAnoexp077() , ab0477s00.getNumexp077() , ab0477s00.getOrdexp077() , ab0477s00.getFolderid077() , ab0477s00.getCartapromotor077() , ab0477s00.getCartacoordinador077() , ab0477s00.getCartaos2077() , ab0477s00.getCartaos2os3077() , ab0477s00.getTareaestudio() , ab0477s00.getEstado077() , ab0477s00.getFecestado077() , ab0477s00.getCtxsub077() , ab0477s00.getCartacontratista077());
    }
    
   /**
    * Finds a list of rows in the Ab0477s00 table.
    * 
    *  ab0477s00 Ab0477s00
    *  jqGridRequestDto JQGridRequestDto
    *  List<Ab0477s00>
    *
    * @param ab0477s00 the ab 0477 s 00
    * @param jqGridRequestDto the jq grid request dto
    * @return the list
    */
	@Transactional (readOnly = true)
    public List<Folder> findAll(Folder ab0477s00, JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder("SELECT  t1.TIPEXP_077 TIPEXP077,t1.TEREXP_077 TEREXP077,t1.ANOEXP_077 ANOEXP077,t1.NUMEXP_077 NUMEXP077,t1.ORDEXP_077 ORDEXP077,t1.FOLDERID_077 FOLDERID077,t1.CARTAPROMOTOR_077 CARTAPROMOTOR077,t1.CARTACOORDINADOR_077 CARTACOORDINADOR077,t1.CARTAOS2_077 CARTAOS2077,t1.CARTAOS2OS3_077 CARTAOS2OS3077,t1.TAREAESTUDIO TAREAESTUDIO,t1.ESTADO_077 ESTADO077,t1.FECESTADO_077 FECESTADO077,t1.CTXSUB_077 CTXSUB077,t1.CARTACONTRATISTA_077 CARTACONTRATISTA077 "); 
		query.append("FROM AB0477S00 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0477s00); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<Folder>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}
	
	/**
	 * Finds rows in the Ab0477s00 table using like.
	 * 
	 *  ab0477s00 Ab0477s00
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean
	 *  List<Ab0477s00>
	 *
	 * @param ab0477s00 the ab 0477 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional (readOnly = true)
    public List<Folder> findAllLike(Folder ab0477s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT  t1.TIPEXP_077 TIPEXP077,t1.TEREXP_077 TEREXP077,t1.ANOEXP_077 ANOEXP077,t1.NUMEXP_077 NUMEXP077,t1.ORDEXP_077 ORDEXP077,t1.FOLDERID_077 FOLDERID077,t1.CARTAPROMOTOR_077 CARTAPROMOTOR077,t1.CARTACOORDINADOR_077 CARTACOORDINADOR077,t1.CARTAOS2_077 CARTAOS2077,t1.CARTAOS2OS3_077 CARTAOS2OS3077,t1.TAREAESTUDIO TAREAESTUDIO,t1.ESTADO_077 ESTADO077,t1.FECESTADO_077 FECESTADO077,t1.CTXSUB_077 CTXSUB077,t1.CARTACONTRATISTA_077 CARTACONTRATISTA077 "); 
        query.append("FROM AB0477S00 t1 ");
      	
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0477s00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		
		return (List<Folder>) this.jdbcTemplate.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */
	
    /**
	 * Counts rows in the Ab0477s00 table.
	 * 
	 *  ab0477s00 Ab0477s00
	 *  Long
	 *
	 * @param ab0477s00 the ab 0477 s 00
	 * @return the long
	 */
    @Transactional (readOnly = true)
    public Long findAllCount(Folder ab0477s00) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB0477S00 t1 ");
		
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0477s00); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);		
		
		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}	
	
	/**
	 * Counts rows in the Ab0477s00 table using like.
	 * 
	 *  ab0477s00 Ab0477s00
	 *  startsWith Boolean
	 *  Long
	 *
	 * @param ab0477s00 the ab 0477 s 00
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional (readOnly = true)
    public Long findAllLikeCount(Folder ab0477s00, Boolean startsWith) {
		StringBuilder query = new StringBuilder("SELECT COUNT(1) FROM AB0477S00 t1 ");

		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0477s00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Reorder the data list of Ab0477s00 selected for rup_table.
	 * 
	 *  ab0477s00 Ab0477s00
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean
	 *  List<TableRowDto<Ab0477s00>>
	 *
	 * @param ab0477s00 the ab 0477 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override 
	public List<TableRowDto<Folder>> reorderSelection(Folder ab0477s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.TIPEXP_077 TIPEXP077,t1.TEREXP_077 TEREXP077,t1.ANOEXP_077 ANOEXP077,t1.NUMEXP_077 NUMEXP077,t1.ORDEXP_077 ORDEXP077,t1.FOLDERID_077 FOLDERID077,t1.CARTAPROMOTOR_077 CARTAPROMOTOR077,t1.CARTACOORDINADOR_077 CARTACOORDINADOR077,t1.CARTAOS2_077 CARTAOS2077,t1.CARTAOS2OS3_077 CARTAOS2OS3077,t1.TAREAESTUDIO TAREAESTUDIO,t1.ESTADO_077 ESTADO077,t1.FECESTADO_077 FECESTADO077,t1.CTXSUB_077 CTXSUB077,t1.CARTACONTRATISTA_077 CARTACONTRATISTA077 "); 
		// FROM
        query.append("FROM AB0477S00 t1 ");
		// FILTRADO
		//Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0477s00,startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");		
		
		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL =  JQGridManager.getReorderQuery(query, jqGridRequestDto, Folder.class, filterParamList, "TIPEXP_077,TEREXP_077,ANOEXP_077,NUMEXP_077,ORDEXP_077,FOLDERID_077,CARTAPROMOTOR_077,CARTACOORDINADOR_077,CARTAOS2_077,CARTAOS2OS3_077,TAREAESTUDIO,ESTADO_077,FECESTADO_077,CTXSUB_077,CARTACONTRATISTA_077" );

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Folder>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams Ab0477s00
	 *  searchParams Ab0477s00
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean
	 *  List<TableRowDto<Ab0477s00>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<Folder>> search(Folder filterParams, Folder searchParams, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.TIPEXP_077 TIPEXP077,t1.TEREXP_077 TEREXP077,t1.ANOEXP_077 ANOEXP077,t1.NUMEXP_077 NUMEXP077,t1.ORDEXP_077 ORDEXP077,t1.FOLDERID_077 FOLDERID077,t1.CARTAPROMOTOR_077 CARTAPROMOTOR077,t1.CARTACOORDINADOR_077 CARTACOORDINADOR077,t1.CARTAOS2_077 CARTAOS2077,t1.CARTAOS2OS3_077 CARTAOS2OS3077,t1.TAREAESTUDIO TAREAESTUDIO,t1.ESTADO_077 ESTADO077,t1.FECESTADO_077 FECESTADO077,t1.CTXSUB_077 CTXSUB077,t1.CARTACONTRATISTA_077 CARTACONTRATISTA077 "); 
		// FROM
        query.append("FROM AB0477S00 t1 ");	
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter.get("params");
		
		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query")).toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch.get("params");
		
		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(query, jqGridRequestDto, Folder.class, filterParamList, searchSQL, searchParamList, from_alias, "TIPEXP_077,TEREXP_077,ANOEXP_077,NUMEXP_077,ORDEXP_077,FOLDERID_077,CARTAPROMOTOR_077,CARTACOORDINADOR_077,CARTAOS2_077,CARTAOS2OS3_077,TAREAESTUDIO,ESTADO_077,FECESTADO_077,CTXSUB_077,CARTACONTRATISTA_077");
		
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(), new RowNumResultSetExtractor<Folder>(this.rwMapPK, jqGridRequestDto), filterParamList.toArray());		
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filterab0477s00 Ab0477s00
	 *  jqGridRequestDto JQGridRequestDto
	 *  startsWith Boolean
	 *
	 * @param filterab0477s00 the filterab 0477 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override
	public void removeMultiple(Folder filterab0477s00, JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder("SELECT t1.TIPEXP_077 TIPEXP077,t1.TEREXP_077 TEREXP077,t1.ANOEXP_077 ANOEXP077,t1.NUMEXP_077 NUMEXP077,t1.ORDEXP_077 ORDEXP077,t1.FOLDERID_077 FOLDERID077,t1.CARTAPROMOTOR_077 CARTAPROMOTOR077,t1.CARTACOORDINADOR_077 CARTACOORDINADOR077,t1.CARTAOS2_077 CARTAOS2077,t1.CARTAOS2OS3_077 CARTAOS2OS3077,t1.TAREAESTUDIO TAREAESTUDIO,t1.ESTADO_077 ESTADO077,t1.FECESTADO_077 FECESTADO077,t1.CTXSUB_077 CTXSUB077,t1.CARTACONTRATISTA_077 CARTACONTRATISTA077 "); 
		// FROM
        query.append("FROM AB0477S00 t1 ");	
		
		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab0477s00, startsWith); 
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		
		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager.getRemoveMultipleQuery(jqGridRequestDto, Folder.class, query, params, "TIPEXP_077,TEREXP_077,ANOEXP_077,NUMEXP_077,ORDEXP_077,FOLDERID_077,CARTAPROMOTOR_077,CARTACOORDINADOR_077,CARTAOS2_077,CARTAOS2OS3_077,TAREAESTUDIO,ESTADO_077,FECESTADO_077,CTXSUB_077,CARTACONTRATISTA_077");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(), params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab0477s00 table.
	 * 
	 *  filterAb0477s00 Ab0477s00
	 *  jqGridRequestDto JQGridRequestDto
	 *  List<JerarquiaDto<Ab0477s00>>
	 *
	 * @param filterAb0477s00 the filter ab 0477 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<JerarquiaDto<Folder>> findAllLikeJerarquia(Folder filterAb0477s00, JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder("SELECT t1.TIPEXP_077 TIPEXP077,t1.TEREXP_077 TEREXP077,t1.ANOEXP_077 ANOEXP077,t1.NUMEXP_077 NUMEXP077,t1.ORDEXP_077 ORDEXP077,t1.FOLDERID_077 FOLDERID077,t1.CARTAPROMOTOR_077 CARTAPROMOTOR077,t1.CARTACOORDINADOR_077 CARTACOORDINADOR077,t1.CARTAOS2_077 CARTAOS2077,t1.CARTAOS2OS3_077 CARTAOS2OS3077,t1.TAREAESTUDIO TAREAESTUDIO,t1.ESTADO_077 ESTADO077,t1.FECESTADO_077 FECESTADO077,t1.CTXSUB_077 CTXSUB077,t1.CARTACONTRATISTA_077 CARTACONTRATISTA077 "); 
		// FROM
        //StringBuilder from = new StringBuilder("FROM AB0477S00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AB0477S00");
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb0477s00, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "TIPEXP_077,TEREXP_077,ANOEXP_077,NUMEXP_077,ORDEXP_077,FOLDERID_077,CARTAPROMOTOR_077,CARTACOORDINADOR_077,CARTAOS2_077,CARTAOS2OS3_077,TAREAESTUDIO,ESTADO_077,FECESTADO_077,CTXSUB_077,CARTACONTRATISTA_077", "ID_PADRE", "NOMBRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query, mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins, businessFilters, businessParams);

		//PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto, query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia, params.toArray());
	}

	/**
	 * Count rows in hierarchy.
	 * 
	 *  filterAb0477s00 Ab0477s00
	 *  jqGridRequestDto JQGridRequestDto
	 *  Long
	 *
	 * @param filterAb0477s00 the filter ab 0477 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Folder filterAb0477s00, JQGridRequestDto jqGridRequestDto) {
		// FROM
        //StringBuilder from = new StringBuilder("FROM AB0477S00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AB0477S00");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb0477s00, false);
		
		//JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "TIPEXP_077,TEREXP_077,ANOEXP_077,NUMEXP_077,ORDEXP_077,FOLDERID_077,CARTAPROMOTOR_077,CARTACOORDINADOR_077,CARTAOS2_077,CARTAOS2OS3_077,TAREAESTUDIO,ESTADO_077,FECESTADO_077,CTXSUB_077,CARTACONTRATISTA_077", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);


		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(), params.toArray());
	}

	/**
	 * Find dependent hierarchical rows.
	 * 
	 *  filterAb0477s00 Ab0477s00
	 *  jqGridRequestDto JQGridRequestDto
	 *  List<TableRowDto<Ab0477s00>>
	 *
	 * @param filterAb0477s00 the filter ab 0477 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Override
	public List<TableRowDto<Folder>> findAllChild(Folder filterAb0477s00, JQGridRequestDto jqGridRequestDto) {
		
		// FROM
        //StringBuilder from = new StringBuilder("FROM AB0477S00 t1 ");
        List<String> from = new ArrayList<String>();
        from.add("AB0477S00");
        
        //TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		
		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		//FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAb0477s00, false);
		
		//MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "TIPEXP_077,TEREXP_077,ANOEXP_077,NUMEXP_077,ORDEXP_077,FOLDERID_077,CARTAPROMOTOR_077,CARTACOORDINADOR_077,CARTAOS2_077,CARTAOS2OS3_077,TAREAESTUDIO,ESTADO_077,FECESTADO_077,CTXSUB_077,CARTACONTRATISTA_077", "ID_PADRE", from, from_alias);
		
		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y condiciones de negocio
		 */
//		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere, "ID", "ID_PADRE", from, from_alias, joins, businessFilters, businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		
		return this.jdbcTemplate.query(query.toString(), new RowNumResultSetExtractor<Folder>(this.rwMapPK, "TIPEXP_077,TEREXP_077,ANOEXP_077,NUMEXP_077,ORDEXP_077,FOLDERID_077,CARTAPROMOTOR_077,CARTACOORDINADOR_077,CARTAOS2_077,CARTAOS2OS3_077,TAREAESTUDIO,ESTADO_077,FECESTADO_077,CTXSUB_077,CARTACONTRATISTA_077"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */
	 	
	/**
	 * Returns a map with the needed value to create the conditions to filter by 
	 * the Ab0477s00 entity .
	 * 
	 *  ab0477s00 Ab0477s00
	 *            Bean with the criteria values to filter by.
	 *  Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 *
	 * @param ab0477s00 the ab 0477 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap (Folder ab0477s00){
		
		StringBuilder where = new StringBuilder(FolderDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0477s00  != null  && ab0477s00.getTipexp077() != null ) {
			where.append(" AND t1.TIPEXP_077 = ?");
			params.add(ab0477s00.getTipexp077());
		}
		if (ab0477s00  != null  && ab0477s00.getTerexp077() != null ) {
			where.append(" AND t1.TEREXP_077 = ?");
			params.add(ab0477s00.getTerexp077());
		}
		if (ab0477s00  != null  && ab0477s00.getAnoexp077() != null ) {
			where.append(" AND t1.ANOEXP_077 = ?");
			params.add(ab0477s00.getAnoexp077());
		}
		if (ab0477s00  != null  && ab0477s00.getNumexp077() != null ) {
			where.append(" AND t1.NUMEXP_077 = ?");
			params.add(ab0477s00.getNumexp077());
		}
		if (ab0477s00  != null  && ab0477s00.getOrdexp077() != null ) {
			where.append(" AND t1.ORDEXP_077 = ?");
			params.add(ab0477s00.getOrdexp077());
		}
		if (ab0477s00  != null  && ab0477s00.getFolderid077() != null ) {
			where.append(" AND t1.FOLDERID_077 = ?");
			params.add(ab0477s00.getFolderid077());
		}
		if (ab0477s00  != null  && ab0477s00.getCartapromotor077() != null ) {
			where.append(" AND t1.CARTAPROMOTOR_077 = ?");
			params.add(ab0477s00.getCartapromotor077());
		}
		if (ab0477s00  != null  && ab0477s00.getCartacoordinador077() != null ) {
			where.append(" AND t1.CARTACOORDINADOR_077 = ?");
			params.add(ab0477s00.getCartacoordinador077());
		}
		if (ab0477s00  != null  && ab0477s00.getCartaos2077() != null ) {
			where.append(" AND t1.CARTAOS2_077 = ?");
			params.add(ab0477s00.getCartaos2077());
		}
		if (ab0477s00  != null  && ab0477s00.getCartaos2os3077() != null ) {
			where.append(" AND t1.CARTAOS2OS3_077 = ?");
			params.add(ab0477s00.getCartaos2os3077());
		}
		if (ab0477s00  != null  && ab0477s00.getTareaestudio() != null ) {
			where.append(" AND t1.TAREAESTUDIO = ?");
			params.add(ab0477s00.getTareaestudio());
		}
		if (ab0477s00  != null  && ab0477s00.getEstado077() != null ) {
			where.append(" AND t1.ESTADO_077 = ?");
			params.add(ab0477s00.getEstado077());
		}
		if (ab0477s00  != null  && ab0477s00.getFecestado077() != null ) {
			where.append(" AND t1.FECESTADO_077 = ?");
			params.add(ab0477s00.getFecestado077());
		}
		if (ab0477s00  != null  && ab0477s00.getCartacontratista077() != null ) {
			where.append(" AND t1.CARTACONTRATISTA_077 = ?");
			params.add(ab0477s00.getCartacontratista077());
		}

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * Returns a map with the needed value to create the conditions to filter by  
	 * the Ab0477s00 entity .
	 * 
	 *  ab0477s00 Ab0477s00
	 *            Bean with the criteria values to filter by.
	 *  startsWith Boolean
	 *  Map created with two keys
	 *         key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the condition sentence.
	 *
	 * @param ab0477s00 the ab 0477 s 00
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap (Folder ab0477s00, Boolean startsWith){
		
		StringBuilder where = new StringBuilder(FolderDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0477s00  != null  && ab0477s00.getTipexp077() != null ) {
			where.append(" AND UPPER(t1.TIPEXP_077) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(ab0477s00.getTipexp077().toUpperCase() +"%");
			}else{
				params.add("%"+ab0477s00.getTipexp077().toUpperCase() +"%");
			}
			where.append(" AND t1.TIPEXP_077 IS NOT NULL");
	     }			
		if (ab0477s00  != null  && ab0477s00.getTerexp077() != null ) {
			where.append(" AND UPPER(t1.TEREXP_077) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(ab0477s00.getTerexp077().toUpperCase() +"%");
			}else{
				params.add("%"+ab0477s00.getTerexp077().toUpperCase() +"%");
			}
			where.append(" AND t1.TEREXP_077 IS NOT NULL");
	     }			
		if (ab0477s00  != null  && ab0477s00.getAnoexp077() != null ) {
			where.append(" AND UPPER(t1.ANOEXP_077) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(ab0477s00.getAnoexp077().toUpperCase() +"%");
			}else{
				params.add("%"+ab0477s00.getAnoexp077().toUpperCase() +"%");
			}
			where.append(" AND t1.ANOEXP_077 IS NOT NULL");
	     }			
		if (ab0477s00  != null  && ab0477s00.getNumexp077() != null ) {
			where.append(" AND t1.NUMEXP_077 = ?");
			params.add(ab0477s00.getNumexp077());
	     }			
		if (ab0477s00  != null  && ab0477s00.getOrdexp077() != null ) {
			where.append(" AND UPPER(t1.ORDEXP_077) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(ab0477s00.getOrdexp077().toUpperCase() +"%");
			}else{
				params.add("%"+ab0477s00.getOrdexp077().toUpperCase() +"%");
			}
			where.append(" AND t1.ORDEXP_077 IS NOT NULL");
	     }			
		if (ab0477s00  != null  && ab0477s00.getFolderid077() != null ) {
			where.append(" AND UPPER(t1.FOLDERID_077) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(ab0477s00.getFolderid077().toUpperCase() +"%");
			}else{
				params.add("%"+ab0477s00.getFolderid077().toUpperCase() +"%");
			}
			where.append(" AND t1.FOLDERID_077 IS NOT NULL");
	     }			
		if (ab0477s00  != null  && ab0477s00.getCartapromotor077() != null ) {
			where.append(" AND UPPER(t1.CARTAPROMOTOR_077) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(ab0477s00.getCartapromotor077().toUpperCase() +"%");
			}else{
				params.add("%"+ab0477s00.getCartapromotor077().toUpperCase() +"%");
			}
			where.append(" AND t1.CARTAPROMOTOR_077 IS NOT NULL");
	     }			
		if (ab0477s00  != null  && ab0477s00.getCartacoordinador077() != null ) {
			where.append(" AND UPPER(t1.CARTACOORDINADOR_077) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(ab0477s00.getCartacoordinador077().toUpperCase() +"%");
			}else{
				params.add("%"+ab0477s00.getCartacoordinador077().toUpperCase() +"%");
			}
			where.append(" AND t1.CARTACOORDINADOR_077 IS NOT NULL");
	     }			
		if (ab0477s00  != null  && ab0477s00.getCartaos2077() != null ) {
			where.append(" AND UPPER(t1.CARTAOS2_077) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(ab0477s00.getCartaos2077().toUpperCase() +"%");
			}else{
				params.add("%"+ab0477s00.getCartaos2077().toUpperCase() +"%");
			}
			where.append(" AND t1.CARTAOS2_077 IS NOT NULL");
	     }			
		if (ab0477s00  != null  && ab0477s00.getCartaos2os3077() != null ) {
			where.append(" AND UPPER(t1.CARTAOS2OS3_077) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(ab0477s00.getCartaos2os3077().toUpperCase() +"%");
			}else{
				params.add("%"+ab0477s00.getCartaos2os3077().toUpperCase() +"%");
			}
			where.append(" AND t1.CARTAOS2OS3_077 IS NOT NULL");
	     }			
		if (ab0477s00  != null  && ab0477s00.getTareaestudio() != null ) {
			where.append(" AND UPPER(t1.TAREAESTUDIO) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(ab0477s00.getTareaestudio().toUpperCase() +"%");
			}else{
				params.add("%"+ab0477s00.getTareaestudio().toUpperCase() +"%");
			}
			where.append(" AND t1.TAREAESTUDIO IS NOT NULL");
	     }			
		if (ab0477s00  != null  && ab0477s00.getEstado077() != null ) {
			where.append(" AND UPPER(t1.ESTADO_077) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(ab0477s00.getEstado077().toUpperCase() +"%");
			}else{
				params.add("%"+ab0477s00.getEstado077().toUpperCase() +"%");
			}
			where.append(" AND t1.ESTADO_077 IS NOT NULL");
	     }			
		if (ab0477s00  != null  && ab0477s00.getFecestado077() != null ) {
			where.append(" AND t1.FECESTADO_077 = ?");
			params.add(ab0477s00.getFecestado077());
	     }			
		if (ab0477s00  != null  && ab0477s00.getCartacontratista077() != null ) {
			where.append(" AND UPPER(t1.CARTACONTRATISTA_077) like ? ESCAPE  '\\'");
			if (startsWith){
				params.add(ab0477s00.getCartacontratista077().toUpperCase() +"%");
			}else{
				params.add("%"+ab0477s00.getCartacontratista077().toUpperCase() +"%");
			}
			where.append(" AND t1.CARTACONTRATISTA_077 IS NOT NULL");
	     }			

		Map<String,Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);
		
		return mapWhere;		
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA
	
	/**
	 * StringBuilder initilization value
	 */
	 public static final int STRING_BUILDER_INIT = 4096;}

